/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.entity.npc;

import lotr.common.entity.npc.LOTREntityNPC;
import lotr.common.item.LOTRItemMug;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class LOTRTradeEntry {
    private final ItemStack tradeItem;
    private int tradeCost;
    private int recentTradeValue;
    private int lockedTicks;

    public LOTRTradeEntry(ItemStack itemstack, int cost) {
        this.tradeItem = itemstack;
        this.tradeCost = cost;
    }

    public ItemStack createTradeItem() {
        return this.tradeItem.func_77946_l();
    }

    public int getCost() {
        return this.tradeCost;
    }

    public void setCost(int cost) {
        this.tradeCost = cost;
    }

    public boolean isAvailable() {
        return this.recentTradeValue < 200 && this.lockedTicks <= 0;
    }

    public boolean updateAvailable(LOTREntityNPC entity) {
        boolean prevAvailable = this.isAvailable();
        if (entity.field_70173_aa % 60 == 0 && this.recentTradeValue > 0) {
            --this.recentTradeValue;
        }
        if (this.lockedTicks > 0) {
            --this.lockedTicks;
        }
        return this.isAvailable() != prevAvailable;
    }

    public boolean matches(ItemStack itemstack) {
        ItemStack tradeCreated = this.createTradeItem();
        if (LOTRItemMug.isItemFullDrink(tradeCreated)) {
            ItemStack tradeDrink = LOTRItemMug.getEquivalentDrink(tradeCreated);
            ItemStack offerDrink = LOTRItemMug.getEquivalentDrink(itemstack);
            return tradeDrink.func_77973_b() == offerDrink.func_77973_b();
        }
        return OreDictionary.itemMatches((ItemStack)tradeCreated, (ItemStack)itemstack, (boolean)false);
    }

    public void doTransaction(int value) {
        this.recentTradeValue += value;
    }

    public void setLockedForTicks(int ticks) {
        this.lockedTicks = ticks;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.tradeItem.func_77955_b(nbt);
        nbt.func_74768_a("Cost", this.tradeCost);
        nbt.func_74768_a("RecentTradeValue", this.recentTradeValue);
        nbt.func_74768_a("LockedTicks", this.lockedTicks);
    }

    public static LOTRTradeEntry readFromNBT(NBTTagCompound nbt) {
        ItemStack savedItem = ItemStack.func_77949_a((NBTTagCompound)nbt);
        if (savedItem != null) {
            int cost = nbt.func_74762_e("Cost");
            LOTRTradeEntry trade = new LOTRTradeEntry(savedItem, cost);
            if (nbt.func_74764_b("RecentTradeValue")) {
                trade.recentTradeValue = nbt.func_74762_e("RecentTradeValue");
            }
            trade.lockedTicks = nbt.func_74762_e("LockedTicks");
            return trade;
        }
        return null;
    }
}

